<?php

/* -----------------------------------------------------------------
 * 	$Id: milando.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Milando {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Milando() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Milando.de';
        $this->v_module_homepage = 'www.milando.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'milando.csv';
        $this->v_filename = 'milando.php';
        $this->v_keyname = 'MILANDO';
        $this->v_linkname = 'milando';
        $this->v_delimiter = ';';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = trim(no_html($p_products_array['products_short_description']));
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_name'] = 'Produktbezeichnung';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_link'] = 'Url des Artikels';
        $t_csv_fields_array['products_image_1'] = 'Bild';
        $t_csv_fields_array['products_currency'] = 'W�hrung';
        $t_csv_fields_array['products_categories'] = 'Kategorie';
        $t_csv_fields_array['products_valid_from'] = 'G�ltig ab';
        $t_csv_fields_array['products_valid_until'] = 'G�ltig  bis';
        $t_csv_fields_array['products_age_rating'] = 'Kz. Altersfreigabe';
        $t_csv_fields_array['products_type'] = 'Kennz. Artikeltyp';
        $t_csv_fields_array['products_id'] = 'Eindeutige Produkt-ID';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_model'] = 'Bestellnummer';
        $t_csv_fields_array['products_meta_keywords'] = 'Suchbegriffe';
        $t_csv_fields_array['products_price_type'] = 'Preistyp';
        $t_csv_fields_array['products_retail_price'] = 'Preis vorher';
        $t_csv_fields_array['products_shippingtime'] = 'Lieferzeit';
        $t_csv_fields_array['products_top_product'] = 'Topprodukt';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_image_2'] = 'Bild 2';
        $t_csv_fields_array['products_image_3'] = 'Bild 3';
        return($t_csv_fields_array);
    }

}

?>